/*

BSD License

Copyright (c) 2002, Brent Simmons
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

*	Redistributions of source code must retain the above copyright notice,
	this list of conditions and the following disclaimer.
*	Redistributions in binary form must reproduce the above copyright notice,
	this list of conditions and the following disclaimer in the documentation
	and/or other materials provided with the distribution.
*	Neither the name of ranchero.com or Brent Simmons nor the names of its
	contributors may be used to endorse or promote products derived
	from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/

/*
	Huevos.h
	Huevos

	Created by Brent Simmons on Thu Mar 28 2002.
	Copyright (c) 2002 Brent Simmons. All rights reserved.
*/


#import <Cocoa/Cocoa.h>
#import <Carbon/Carbon.h>


enum {
	controlKeyPref = 0,
	optionKeyPref,
	commandKeyPref
	};


enum {
	escapeKeyPref = 0,
	f1KeyPref,
	f2KeyPref,
	f3KeyPref,
	f4KeyPref,
	f5KeyPref,
	f6KeyPref,
	f7KeyPref,
	f8KeyPref,
	f9KeyPref,
	f10KeyPref,
	f11KeyPref,
	f12KeyPref
	};


#define lastSearchEnginePrefsKey @"lastSearchEngine"
#define lastSearchStringPrefsKey @"lastSearchString"
#define defaultSearchEnginesFileName @"DefaultSearchEngines"
#define defaultCommandKeysFileName @"DefaultCommandKeys"
#define searchEnginesPrefsKey @"Search Engines"
#define commandKeysPrefsKey @"Command Keys"
#define defaultSearchEngineName @"Google"
#define useFloatingPanelPrefsKey @"useFloatingPanel"


@interface Huevos : NSObject {
	
	/*Outlets*/
	
	IBOutlet NSTextField *searchField;	
	IBOutlet NSPopUpButton *popupButton;	
	IBOutlet NSPanel *mainWindow;
	IBOutlet NSMenuItem *floatMenuItem;
	IBOutlet NSMenuItem *newMenuItem;
	
	BOOL useFloatingPanel;
	}


- (void) awakeFromNib;

+ (id) sharedInstance;


/*Actions*/


- (IBAction) openMainWindow: (id) sender;

- (IBAction) doSearch: (id) sender;

- (IBAction) setFloating: (id) sender;

- (IBAction) openHelpInBrowser: (id) sender;


/*String utility*/

- (NSString *) replaceAll: (NSString *) searchFor with: (NSString *) replaceWith
	inString: (NSString *) s;


/*UI stuff*/

- (void) setFloatingMenuItemState;

- (void) updatePopupMenu;

- (void) setWindowFloats;

- (void) goUpOneSearchEngine;	

- (void) goDownOneSearchEngine;
	
- (BOOL) validateMenuItem: (NSMenuItem *) menuItem;


/*HotKey prefs*/

- (int) hotkeyModifierCode;	

- (int) hotKeyCode;

- (void) setupHotKey;	


/*Notifications*/

- (void) handleSearchEnginesChange: (NSNotification *) note;	

- (void) handleHotKeyChange: (NSNotification *) note;	

- (BOOL) applicationShouldHandleReopen: (NSApplication *) app hasVisibleWindows: (BOOL) fl;


/*General prefs*/

- (void) rememberLastSearch;

- (void) saveLastSearchParams;	

- (void) getFloatingPref;	

- (void) setFloatingPref;

- (void) setupPrefs;


@end
